import json
import requests
import os
from easydict import EasyDict


# Find all links to JSON files
file_names = [
    "biomes.json",
    "blocks.json",
    "effects.json",
    "enchantments.json",
    "entities.json",
    "foods.json",
    "instruments.json",
    "items.json",
    "particles.json",
    "recipes.json"
    ]


def download_minecraft_data():
    version = "1.19"
    # GitHub directory URL
    raw_base_url = f"https://raw.githubusercontent.com/PrismarineJS/minecraft-data/master/data/pc/{version}/"

    # Directory to save the downloaded JSON files
    save_dir = os.path.join(os.path.dirname(__file__), "minecraft_data")
    if not os.path.exists(save_dir):
        os.makedirs(save_dir)
    else:
        print(f"Directory {save_dir} already exists. Skipping download.")
        return

    for file_name in file_names:
            
        file_url = raw_base_url + file_name
        
        print(f"Downloading {file_name} from {file_url}...")
        
        file_response = requests.get(file_url)
        if file_name == "recipes.json":
            recipes_dict = json.loads(file_response.content)
            file_path = os.path.join(save_dir, "items.json")
            with open(file_path, "r", encoding="utf-8") as f:
                items_list = json.load(f)
                for i, item in enumerate(items_list):
                    if str(item["id"]) in recipes_dict:
                        items_list[i]["recipe"] = recipes_dict[str(item["id"])]

            with open(file_path, "w", encoding="utf-8") as f:
                json.dump(items_list, f, indent=4)


        file_path = os.path.join(save_dir, file_name)
        
        with open(file_path, "wb") as file:
            file.write(file_response.content)

        print(f"{file_name} downloaded and saved to {file_path}")

    print("All JSON files downloaded.")

download_minecraft_data()


class MetaDict:
    def __init__(self):
        for file_name in file_names:
            if 'recipes' in file_name:
                continue
            file_path = os.path.join(os.path.dirname(__file__), "minecraft_data", file_name)
            data = json.load(open(file_path, "r"))

            domain = file_name.split(".")[0]
            domain_byname = f"{domain}ByName"
            self.__setattr__(domain, {item['id']: EasyDict(item) for item in data})
            self.__setattr__(domain_byname, EasyDict({item['name']: EasyDict(item) for item in data}))

META_DATA = MetaDict()
